/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.TypedValue;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.GoogleVrApi;
import com.unity3d.player.GoogleVrProxy;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.NetworkConnectivity;
import com.unity3d.player.g;
import com.unity3d.player.j;
import com.unity3d.player.k;
import com.unity3d.player.l;
import com.unity3d.player.m;
import com.unity3d.player.n;
import com.unity3d.player.q;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class UnityPlayer
extends FrameLayout
implements IUnityPlayerLifecycleEvents,
com.unity3d.player.f {
    public static Activity currentActivity = null;
    private int mInitialScreenOrientation = -1;
    private boolean mMainDisplayOverride = false;
    private boolean mIsFullscreen = true;
    private n mState = new n();
    private final ConcurrentLinkedQueue m_Events = new ConcurrentLinkedQueue();
    private BroadcastReceiver mKillingIsMyBusiness = null;
    private OrientationEventListener mOrientationListener = null;
    private int mNaturalOrientation;
    private static final int ANR_TIMEOUT_SECONDS = 4;
    private static final int RUN_STATE_CHANGED_MSG_CODE = 2269;
    e m_MainThread = new e(0);
    private boolean m_AddPhoneCallListener = false;
    private c m_PhoneCallListener = new c(0);
    private TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private l m_SplashScreen;
    private GoogleARCoreApi m_ARCoreApi = null;
    private a m_FakeListener = new a();
    private Camera2Wrapper m_Camera2Wrapper = null;
    private HFPStatus m_HFPStatus = null;
    private AudioVolumeHandler m_AudioVolumeHandler = null;
    private Uri m_launchUri = null;
    private NetworkConnectivity m_NetworkConnectivity = null;
    private IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents = null;
    private Context mContext;
    private SurfaceView mGlView;
    private boolean mQuitting;
    private boolean mProcessKillRequested = true;
    private q mVideoPlayerProxy;
    k mSoftInputDialog = null;
    private static final String SPLASH_ENABLE_METADATA_NAME = "unity.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "unity.splash-mode";
    private static final String TANGO_ENABLE_METADATA_NAME = "unity.tango-enable";

    public UnityPlayer(Context context) {
        this(context, null);
    }

    public UnityPlayer(Context context, IUnityPlayerLifecycleEvents iUnityPlayerLifecycleEvents) {
        super(context);
        this.m_UnityPlayerLifecycleEvents = iUnityPlayerLifecycleEvents;
        if (context instanceof Activity) {
            currentActivity = (Activity)context;
            this.mInitialScreenOrientation = currentActivity.getRequestedOrientation();
            this.m_launchUri = currentActivity.getIntent().getData();
        }
        this.EarlyEnableFullScreenIfVrLaunched(currentActivity);
        this.mContext = context;
        iUnityPlayerLifecycleEvents = this.getResources().getConfiguration();
        this.mNaturalOrientation = this.getNaturalOrientation(((Configuration)iUnityPlayerLifecycleEvents).orientation);
        if (currentActivity != null && this.getSplashEnabled()) {
            this.m_SplashScreen = new l(this.mContext, l.a.a()[this.getSplashMode()]);
            this.addView(this.m_SplashScreen);
        }
        UnityPlayer.loadNative(this.mContext.getApplicationInfo());
        if (!n.c()) {
            context = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n2) {
                    UnityPlayer.this.finish();
                }
            }).setMessage((CharSequence)"Your hardware does not support this application, sorry!").create();
            context.setCancelable(false);
            context.show();
            return;
        }
        this.initJni(context);
        this.mState.c(true);
        this.mGlView = this.CreateGlView();
        this.mGlView.setContentDescription((CharSequence)this.GetGlViewContentDescription(context));
        this.addView((View)this.mGlView);
        this.bringChildToFront(this.m_SplashScreen);
        this.mQuitting = false;
        this.hideStatusBar();
        this.m_TelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.m_ClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        this.m_Camera2Wrapper = new Camera2Wrapper(this.mContext);
        this.m_HFPStatus = new HFPStatus(this.mContext);
        this.m_MainThread.start();
    }

    private int getNaturalOrientation(int n2) {
        int n3 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n3 == 0 || n3 == 2) && n2 == 2 || (n3 == 1 || n3 == 3) && n2 == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public void onUnityPlayerUnloaded() {
    }

    @Override
    public void onUnityPlayerQuitted() {
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
            return;
        }
        sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
    }

    private String GetGlViewContentDescription(Context context) {
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", context.getPackageName()));
    }

    private void DisableStaticSplashScreen() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.removeView(UnityPlayer.this.m_SplashScreen);
                UnityPlayer.this.m_SplashScreen = null;
            }
        });
    }

    private void EarlyEnableFullScreenIfVrLaunched(Activity activity) {
        if (activity != null && activity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false) && activity.getWindow() != null && (activity = activity.getWindow().getDecorView()) != null) {
            activity.setSystemUiVisibility(7);
        }
    }

    private boolean IsWindowTranslucent() {
        if (currentActivity == null) {
            return false;
        }
        TypedValue typedValue = new TypedValue();
        if (currentActivity.getTheme().resolveAttribute(16842840, typedValue, true) && typedValue.type == 18) {
            return typedValue.data != 0;
        }
        return false;
    }

    private SurfaceView CreateGlView() {
        SurfaceView surfaceView = new SurfaceView(this.mContext);
        surfaceView.setId(this.mContext.getResources().getIdentifier("unitySurfaceView", "id", this.mContext.getPackageName()));
        if (this.IsWindowTranslucent()) {
            surfaceView.getHolder().setFormat(-3);
            surfaceView.setZOrderOnTop(true);
        } else {
            surfaceView.getHolder().setFormat(-1);
        }
        surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public final void surfaceCreated(SurfaceHolder surfaceHolder) {
                UnityPlayer.this.updateGLDisplay(0, surfaceHolder.getSurface());
            }

            public final void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
                UnityPlayer.this.updateGLDisplay(0, surfaceHolder.getSurface());
                UnityPlayer.this.sendSurfaceChangedEvent();
            }

            public final void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                UnityPlayer.this.updateGLDisplay(0, null);
            }
        });
        surfaceView.setFocusable(true);
        surfaceView.setFocusableInTouchMode(true);
        return surfaceView;
    }

    private void sendSurfaceChangedEvent() {
        if (!n.c() || !this.mState.e()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeSendSurfaceChangedEvent();
            }
        };
        this.m_MainThread.d(runnable);
    }

    private void updateGLDisplay(int n2, Surface surface) {
        if (this.mMainDisplayOverride) {
            return;
        }
        this.updateDisplayInternal(n2, surface);
    }

    private boolean updateDisplayInternal(final int n2, final Surface surface) {
        if (!n.c() || !this.mState.e()) {
            return false;
        }
        final Semaphore semaphore = new Semaphore(0);
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeRecreateGfxState(n2, surface);
                semaphore.release();
            }
        };
        if (n2 == 0) {
            if (surface == null) {
                this.m_MainThread.b(runnable);
            } else {
                this.m_MainThread.c(runnable);
            }
        } else {
            runnable.run();
        }
        if (surface == null && n2 == 0) {
            try {
                if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                    g.Log(5, "Timeout while trying detaching primary window.");
                }
            }
            catch (InterruptedException interruptedException) {
                g.Log(5, "UI thread got interrupted while trying to detach the primary window from the Unity Engine.");
            }
        }
        return true;
    }

    public boolean displayChanged(int n2, Surface surface) {
        if (n2 == 0) {
            this.mMainDisplayOverride = surface != null;
            this.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.mMainDisplayOverride) {
                        UnityPlayer.this.removeView((View)UnityPlayer.this.mGlView);
                        return;
                    }
                    UnityPlayer.this.addView((View)UnityPlayer.this.mGlView);
                }
            });
        }
        return this.updateDisplayInternal(n2, surface);
    }

    public static void UnitySendMessage(String string, String string2, String string3) {
        if (!n.c()) {
            g.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, string3.getBytes("UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void finish() {
        if (this.mContext instanceof Activity && !((Activity)this.mContext).isFinishing()) {
            ((Activity)this.mContext).finish();
        }
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).runOnUiThread(runnable);
            return;
        }
        g.Log(5, "Not running Unity from an Activity; ignored...");
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public void init(int n2, boolean bl) {
    }

    public View getView() {
        return this;
    }

    public Bundle getSettings() {
        return Bundle.EMPTY;
    }

    public void quit() {
        this.destroy();
    }

    public void newIntent(Intent intent) {
        this.m_launchUri = intent.getData();
        this.m_MainThread.e();
    }

    public void destroy() {
        if (GoogleVrApi.b() != null) {
            GoogleVrApi.a();
        }
        if (this.m_Camera2Wrapper != null) {
            this.m_Camera2Wrapper.a();
            this.m_Camera2Wrapper = null;
        }
        if (this.m_HFPStatus != null) {
            this.m_HFPStatus.a();
            this.m_HFPStatus = null;
        }
        if (this.m_NetworkConnectivity != null) {
            this.m_NetworkConnectivity.b();
            this.m_NetworkConnectivity = null;
        }
        this.mQuitting = true;
        if (!this.mState.d()) {
            this.pause();
        }
        this.m_MainThread.a();
        try {
            this.m_MainThread.join(4000L);
        }
        catch (InterruptedException interruptedException) {
            this.m_MainThread.interrupt();
        }
        if (this.mKillingIsMyBusiness != null) {
            this.mContext.unregisterReceiver(this.mKillingIsMyBusiness);
        }
        this.mKillingIsMyBusiness = null;
        if (n.c()) {
            this.removeAllViews();
        }
        if (this.mProcessKillRequested) {
            if (this.m_UnityPlayerLifecycleEvents != null) {
                this.m_UnityPlayerLifecycleEvents.onUnityPlayerQuitted();
            } else {
                this.onUnityPlayerQuitted();
            }
            this.kill();
        }
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        Process.killProcess((int)Process.myPid());
    }

    public void pause() {
        GoogleVrProxy googleVrProxy;
        if (this.m_ARCoreApi != null) {
            this.m_ARCoreApi.pauseARCore();
        }
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.a();
        }
        if ((googleVrProxy = GoogleVrApi.b()) != null) {
            googleVrProxy.pauseGvrLayout();
        }
        if (this.m_AudioVolumeHandler != null) {
            this.m_AudioVolumeHandler.a();
            this.m_AudioVolumeHandler = null;
        }
        this.pauseUnity();
    }

    private void pauseUnity() {
        this.reportSoftInputStr(null, 1, true);
        if (!this.mState.g()) {
            return;
        }
        if (n.c()) {
            final Semaphore semaphore = new Semaphore(0);
            Runnable runnable = this.isFinishing() ? new Runnable(){

                @Override
                public final void run() {
                    UnityPlayer.this.shutdown();
                    semaphore.release();
                }
            } : new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.nativePause()) {
                        UnityPlayer.this.mQuitting = true;
                        UnityPlayer.this.shutdown();
                        semaphore.release(2);
                        return;
                    }
                    semaphore.release();
                }
            };
            this.m_MainThread.a(runnable);
            try {
                if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                    g.Log(5, "Timeout while trying to pause the Unity Engine.");
                }
            }
            catch (InterruptedException interruptedException) {
                g.Log(5, "UI thread got interrupted while trying to pause the Unity Engine.");
            }
            if (semaphore.drainPermits() > 0) {
                this.destroy();
            }
        }
        this.mState.d(false);
        this.mState.b(true);
        if (this.m_AddPhoneCallListener) {
            this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 0);
        }
    }

    public void resume() {
        if (this.m_ARCoreApi != null) {
            this.m_ARCoreApi.resumeARCore();
        }
        this.mState.b(false);
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.b();
        }
        this.checkResumePlayer();
        this.nativeRestartActivityIndicator();
        GoogleVrProxy googleVrProxy = GoogleVrApi.b();
        if (googleVrProxy != null) {
            googleVrProxy.b();
        }
        this.m_AudioVolumeHandler = new AudioVolumeHandler(this.mContext);
    }

    public void lowMemory() {
        if (!n.c()) {
            return;
        }
        this.queueGLThreadEvent(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeLowMemory();
            }
        });
    }

    private void shutdown() {
        this.mProcessKillRequested = this.nativeDone();
        this.mState.c(false);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    private void checkResumePlayer() {
        if (!this.mState.f()) {
            return;
        }
        this.mState.d(true);
        this.queueGLThreadEvent(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeResume();
            }
        });
        this.m_MainThread.b();
    }

    protected boolean skipPermissionsDialog() {
        if (j.b && currentActivity != null) {
            return j.d.a(currentActivity);
        }
        return false;
    }

    protected void requestUserAuthorization(String string) {
        if (j.b && string != null && !string.isEmpty() && currentActivity != null) {
            j.d.a(currentActivity, string);
        }
    }

    protected int getNetworkConnectivity() {
        if (j.c) {
            if (this.m_NetworkConnectivity == null) {
                this.m_NetworkConnectivity = new NetworkConnectivity(this.mContext);
            }
            return this.m_NetworkConnectivity.a();
        }
        return 0;
    }

    public void configurationChanged(Configuration object) {
        if (this.mGlView instanceof SurfaceView) {
            this.mGlView.getHolder().setSizeFromLayout();
        }
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.c();
        }
        if ((object = GoogleVrApi.b()) != null) {
            ((GoogleVrProxy)object).c();
        }
    }

    public void windowFocusChanged(boolean bl) {
        this.mState.a(bl);
        if (!this.mState.e()) {
            return;
        }
        if (bl) {
            this.m_MainThread.c();
        } else {
            this.m_MainThread.d();
        }
        this.checkResumePlayer();
    }

    protected static boolean loadLibraryStatic(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            g.Log(6, "Unable to find " + string);
            return false;
        }
        catch (Exception exception) {
            g.Log(6, "Unknown error " + exception);
            return false;
        }
        return true;
    }

    protected boolean loadLibrary(String string) {
        return UnityPlayer.loadLibraryStatic(string);
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    private final native void initJni(Context var1);

    private final native boolean nativeRender();

    private final native void nativeSetInputArea(int var1, int var2, int var3, int var4);

    private final native void nativeSetKeyboardIsVisible(boolean var1);

    private final native void nativeSetInputString(String var1);

    private final native void nativeSetInputSelection(int var1, int var2);

    private final native void nativeSoftInputCanceled();

    private final native void nativeSoftInputLostFocus();

    private final native void nativeReportKeyboardConfigChanged();

    private final native boolean nativePause();

    private final native void nativeResume();

    private final native void nativeLowMemory();

    private final native void nativeApplicationUnload();

    private final native void nativeFocusChanged(boolean var1);

    private final native void nativeRecreateGfxState(int var1, Surface var2);

    private final native void nativeSendSurfaceChangedEvent();

    private final native boolean nativeDone();

    private final native void nativeSoftInputClosed();

    private final native boolean nativeInjectEvent(InputEvent var1);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeRestartActivityIndicator();

    private final native void nativeSetLaunchURL(String var1);

    private final native void nativeOrientationChanged(int var1, int var2);

    private static void loadNative(ApplicationInfo applicationInfo) {
        if (NativeLoader.load(applicationInfo.nativeLibraryDir)) {
            n.a();
            return;
        }
        g.Log(6, "NativeLoader.load failure, Unity libraries were not loaded.");
    }

    private static void unloadNative() {
        if (!n.c()) {
            return;
        }
        if (!NativeLoader.unload()) {
            throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
        }
        n.b();
    }

    protected void showSoftInput(final String string, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final String string2, final int n3, final boolean bl5) {
        final UnityPlayer unityPlayer = this;
        this.postOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.mSoftInputDialog = new k(UnityPlayer.this.mContext, unityPlayer, string, n2, bl, bl2, bl3, string2, n3, bl5);
                UnityPlayer.this.mSoftInputDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public final void onCancel(DialogInterface dialogInterface) {
                        UnityPlayer.this.nativeSoftInputLostFocus();
                        UnityPlayer.this.reportSoftInputStr(null, 1, false);
                    }
                });
                UnityPlayer.this.mSoftInputDialog.show();
                UnityPlayer.this.nativeReportKeyboardConfigChanged();
            }
        });
    }

    protected void hideSoftInput() {
        this.postOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.reportSoftInputArea(new Rect());
                UnityPlayer.this.reportSoftInputIsVisible(false);
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.dismiss();
                    UnityPlayer.this.mSoftInputDialog = null;
                    UnityPlayer.this.nativeReportKeyboardConfigChanged();
                }
            }
        });
    }

    protected void setSoftInputStr(final String string) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null && string != null) {
                    UnityPlayer.this.mSoftInputDialog.a(string);
                }
            }
        });
    }

    protected void setCharacterLimit(final int n2) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(n2);
                }
            }
        });
    }

    protected void setHideInputField(final boolean bl) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(bl);
                }
            }
        });
    }

    protected void setSelection(final int n2, final int n3) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(n2, n3);
                }
            }
        });
    }

    protected String getKeyboardLayout() {
        if (this.mSoftInputDialog == null) {
            return null;
        }
        return this.mSoftInputDialog.a();
    }

    protected void reportSoftInputStr(final String string, final int n2, final boolean bl) {
        if (n2 == 1) {
            this.hideSoftInput();
        }
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                if (bl) {
                    UnityPlayer.this.nativeSoftInputCanceled();
                } else if (string != null) {
                    UnityPlayer.this.nativeSetInputString(string);
                }
                if (n2 == 1) {
                    UnityPlayer.this.nativeSoftInputClosed();
                }
            }
        });
    }

    protected void reportSoftInputSelection(final int n2, final int n3) {
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetInputSelection(n2, n3);
            }
        });
    }

    protected void reportSoftInputArea(final Rect rect) {
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetInputArea(rect.left, rect.top, rect.right, rect.bottom);
            }
        });
    }

    protected void reportSoftInputIsVisible(final boolean bl) {
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetKeyboardIsVisible(bl);
            }
        });
    }

    protected void setClipboardText(String string) {
        string = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        this.m_ClipboardManager.setPrimaryClip((ClipData)string);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        if (this.m_launchUri != null) {
            return this.m_launchUri.toString();
        }
        return null;
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && currentActivity != null && this.getTangoEnabled()) {
            this.m_ARCoreApi = new GoogleARCoreApi();
            this.m_ARCoreApi.initializeARCore(currentActivity);
            if (!this.mState.d()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean initializeGoogleVr() {
        GoogleVrProxy googleVrProxy = GoogleVrApi.b();
        if (googleVrProxy == null) {
            GoogleVrApi.a(this);
            googleVrProxy = GoogleVrApi.b();
            if (googleVrProxy == null) {
                g.Log(6, "Unable to create Google VR subsystem.");
                return false;
            }
        }
        final GoogleVrProxy googleVrProxy2 = googleVrProxy;
        final Semaphore semaphore = new Semaphore(0);
        final Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.injectEvent((InputEvent)new KeyEvent(0, 4));
                UnityPlayer.this.injectEvent((InputEvent)new KeyEvent(1, 4));
            }
        };
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (!googleVrProxy2.a(currentActivity, UnityPlayer.this.mContext, UnityPlayer.this.CreateGlView(), runnable)) {
                    g.Log(6, "Unable to initialize Google VR subsystem.");
                }
                if (currentActivity != null) {
                    googleVrProxy2.a(currentActivity.getIntent());
                }
                semaphore.release();
            }
        });
        try {
            if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                g.Log(5, "Timeout while trying to initialize Google VR.");
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            g.Log(5, "UI thread was interrupted while initializing Google VR. " + interruptedException.getLocalizedMessage());
            return false;
        }
        return googleVrProxy.a();
    }

    protected boolean showVideoPlayer(String string, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        boolean bl2;
        if (this.mVideoPlayerProxy == null) {
            this.mVideoPlayerProxy = new q(this);
        }
        if (bl2 = this.mVideoPlayerProxy.a(this.mContext, string, n2, n3, n4, bl, n5, n6, new q.a(){

            @Override
            public final void a() {
                UnityPlayer.this.mVideoPlayerProxy = null;
            }
        })) {
            this.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.nativeIsAutorotationOn() && UnityPlayer.this.mContext instanceof Activity) {
                        ((Activity)UnityPlayer.this.mContext).setRequestedOrientation(UnityPlayer.this.mInitialScreenOrientation);
                    }
                }
            });
        }
        return bl2;
    }

    protected void notifyOnUnityPlayerUnloaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.pause();
                UnityPlayer.this.windowFocusChanged(false);
                if (UnityPlayer.this.m_UnityPlayerLifecycleEvents != null) {
                    UnityPlayer.this.m_UnityPlayerLifecycleEvents.onUnityPlayerUnloaded();
                    return;
                }
                UnityPlayer.this.onUnityPlayerUnloaded();
            }
        });
    }

    private ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    private boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getTangoEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(TANGO_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void executeGLThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_Events.poll()) != null) {
            runnable.run();
        }
    }

    protected void disableLogger() {
        g.a = true;
    }

    private void queueGLThreadEvent(Runnable runnable) {
        if (!n.c()) {
            return;
        }
        if (Thread.currentThread() == this.m_MainThread) {
            runnable.run();
            return;
        }
        this.m_Events.add(runnable);
    }

    private void queueGLThreadEvent(f f2) {
        if (this.isFinishing()) {
            return;
        }
        this.queueGLThreadEvent((Runnable)f2);
    }

    protected boolean isFinishing() {
        return this.mQuitting || (this.mQuitting = this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing());
    }

    private void hideStatusBar() {
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).getWindow().setFlags(1024, 1024);
        }
    }

    public boolean injectEvent(InputEvent inputEvent) {
        if (!n.c()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyMultiple(int n2, int n3, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyLongPress(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.injectEvent((InputEvent)motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.injectEvent((InputEvent)motionEvent);
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.d()) {
            this.pause();
            bl = true;
        }
        if (!(view == null || (viewParent = view.getParent()) instanceof UnityPlayer && (UnityPlayer)viewParent == this)) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            this.addView(view);
            this.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == this) {
            view2.setVisibility(8);
            this.removeView(view2);
        }
        if (bl) {
            this.resume();
        }
    }

    @Override
    public boolean addViewToPlayer(View view, boolean bl) {
        this.swapViews(view, (View)(bl ? this.mGlView : null));
        boolean bl2 = view.getParent() == this;
        bl = bl && this.mGlView.getParent() == null;
        boolean bl3 = this.mGlView.getParent() == this;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                g.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                g.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    @Override
    public void removeViewFromPlayer(View view) {
        this.swapViews((View)this.mGlView, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = this.mGlView.getParent() == this;
        if (!(bl && bl2)) {
            if (!bl) {
                g.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                g.Log(6, "removeVireFromPlayer: Failure agging old view to hierarchy");
            }
        }
    }

    @Override
    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        g.Log(6, stringBuilder.toString());
    }

    public String getNetworkProxySettings(String charSequence) {
        String string;
        String string2;
        if (((String)charSequence).startsWith("http:")) {
            charSequence = "http.proxyHost";
            string2 = "http.proxyPort";
            string = "http.nonProxyHosts";
        } else if (((String)charSequence).startsWith("https:")) {
            charSequence = "https.proxyHost";
            string2 = "https.proxyPort";
            string = "http.nonProxyHosts";
        } else {
            return null;
        }
        charSequence = System.getProperties().getProperty((String)charSequence);
        if (charSequence == null || "".equals(charSequence)) {
            return null;
        }
        charSequence = new StringBuilder((String)charSequence);
        string2 = System.getProperties().getProperty(string2);
        if (string2 != null && !"".equals(string2)) {
            ((StringBuilder)charSequence).append(":").append(string2);
        }
        if ((string2 = System.getProperties().getProperty(string)) != null && !"".equals(string2)) {
            ((StringBuilder)charSequence).append('\n').append(string2);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public boolean startOrientationListener(int n2) {
        if (this.mOrientationListener != null) {
            g.Log(5, "Orientation Listener already started.");
            return false;
        }
        this.mOrientationListener = new OrientationEventListener(this.mContext, n2){

            public final void onOrientationChanged(int n2) {
                UnityPlayer.this.m_MainThread.a(UnityPlayer.this.mNaturalOrientation, n2);
            }
        };
        if (this.mOrientationListener.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        g.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        if (this.mOrientationListener == null) {
            g.Log(5, "Orientation Listener was not started.");
            return false;
        }
        this.mOrientationListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    static {
        new m().a();
        try {
            System.loadLibrary("main");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            g.Log(6, "Failed to load 'libmain.so', the application will terminate.");
            throw unsatisfiedLinkError;
        }
    }

    private abstract class f
    implements Runnable {
        private f() {
        }

        @Override
        public final void run() {
            if (!UnityPlayer.this.isFinishing()) {
                this.a();
            }
        }

        public abstract void a();

        /* synthetic */ f(byte by) {
            this();
        }
    }

    final class a
    implements SensorEventListener {
        a() {
        }

        public final void onAccuracyChanged(Sensor sensor, int n2) {
        }

        public final void onSensorChanged(SensorEvent sensorEvent) {
        }
    }

    private final class c
    extends PhoneStateListener {
        private c() {
        }

        public final void onCallStateChanged(int n2, String string) {
            UnityPlayer.this.nativeMuteMasterAudio(n2 == 1);
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private final class e
    extends Thread {
        Handler a;
        boolean b = false;
        boolean c = false;
        int d = com.unity3d.player.UnityPlayer$b.b;
        int e = 0;
        int f;
        int g;
        int h = 5;

        private e() {
        }

        @Override
        public final void run() {
            this.setName("UnityMain");
            Looper.prepare();
            this.a = new Handler(new Handler.Callback(){

                private void a() {
                    if (e.this.d == com.unity3d.player.UnityPlayer$b.c && e.this.c) {
                        UnityPlayer.this.nativeFocusChanged(true);
                        e.this.d = com.unity3d.player.UnityPlayer$b.a;
                    }
                }

                public final boolean handleMessage(Message object) {
                    if (object.what != 2269) {
                        return false;
                    }
                    object = (d)((Object)object.obj);
                    if (object == com.unity3d.player.UnityPlayer$d.h) {
                        --e.this.e;
                        UnityPlayer.this.executeGLThreadJobs();
                        if (!e.this.b) {
                            return true;
                        }
                        if (!e.this.c) {
                            return true;
                        }
                        if (e.this.h >= 0) {
                            if (e.this.h == 0 && UnityPlayer.this.getSplashEnabled()) {
                                UnityPlayer.this.DisableStaticSplashScreen();
                            }
                            --e.this.h;
                        }
                        if (!UnityPlayer.this.isFinishing() && !UnityPlayer.this.nativeRender()) {
                            UnityPlayer.this.finish();
                        }
                    } else if (object == com.unity3d.player.UnityPlayer$d.c) {
                        Looper.myLooper().quit();
                    } else if (object == com.unity3d.player.UnityPlayer$d.b) {
                        e.this.b = true;
                    } else if (object == com.unity3d.player.UnityPlayer$d.a) {
                        e.this.b = false;
                    } else if (object == com.unity3d.player.UnityPlayer$d.d) {
                        e.this.c = false;
                    } else if (object == com.unity3d.player.UnityPlayer$d.e) {
                        e.this.c = true;
                        this.a();
                    } else if (object == com.unity3d.player.UnityPlayer$d.f) {
                        if (e.this.d == com.unity3d.player.UnityPlayer$b.a) {
                            UnityPlayer.this.nativeFocusChanged(false);
                        }
                        e.this.d = com.unity3d.player.UnityPlayer$b.b;
                    } else if (object == com.unity3d.player.UnityPlayer$d.g) {
                        e.this.d = com.unity3d.player.UnityPlayer$b.c;
                        this.a();
                    } else if (object == com.unity3d.player.UnityPlayer$d.i) {
                        UnityPlayer.this.nativeSetLaunchURL(UnityPlayer.this.getLaunchURL());
                    } else if (object == com.unity3d.player.UnityPlayer$d.j) {
                        UnityPlayer.this.nativeOrientationChanged(e.this.f, e.this.g);
                    }
                    if (e.this.b && e.this.e <= 0) {
                        Message.obtain((Handler)e.this.a, (int)2269, (Object)((Object)com.unity3d.player.UnityPlayer$d.h)).sendToTarget();
                        ++e.this.e;
                    }
                    return true;
                }
            });
            Looper.loop();
        }

        public final void a() {
            this.a(com.unity3d.player.UnityPlayer$d.c);
        }

        public final void b() {
            this.a(com.unity3d.player.UnityPlayer$d.b);
        }

        public final void a(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            this.a(com.unity3d.player.UnityPlayer$d.a);
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
        }

        public final void c() {
            this.a(com.unity3d.player.UnityPlayer$d.g);
        }

        public final void d() {
            this.a(com.unity3d.player.UnityPlayer$d.f);
        }

        public final void b(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            this.a(com.unity3d.player.UnityPlayer$d.d);
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
        }

        public final void c(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
            this.a(com.unity3d.player.UnityPlayer$d.e);
        }

        public final void d(Runnable runnable) {
            if (this.a != null) {
                Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
            }
        }

        public final void e() {
            this.a(com.unity3d.player.UnityPlayer$d.i);
        }

        private void a(d d2) {
            if (this.a != null) {
                Message.obtain((Handler)this.a, (int)2269, (Object)((Object)d2)).sendToTarget();
            }
        }

        public final void a(int n2, int n3) {
            this.f = n2;
            this.g = n3;
            this.a(com.unity3d.player.UnityPlayer$d.j);
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    static final class b
    extends Enum {
        public static final /* enum */ int a = 1;
        public static final /* enum */ int b = 2;
        public static final /* enum */ int c = 3;
        private static final /* synthetic */ int[] d;

        static {
            d = new int[]{a, b, c};
        }
    }

    static final class d
    extends Enum {
        public static final /* enum */ d a = new d("PAUSE", 0);
        public static final /* enum */ d b = new d("RESUME", 1);
        public static final /* enum */ d c = new d("QUIT", 2);
        public static final /* enum */ d d = new d("SURFACE_LOST", 3);
        public static final /* enum */ d e = new d("SURFACE_ACQUIRED", 4);
        public static final /* enum */ d f = new d("FOCUS_LOST", 5);
        public static final /* enum */ d g = new d("FOCUS_GAINED", 6);
        public static final /* enum */ d h = new d("NEXT_FRAME", 7);
        public static final /* enum */ d i = new d("URL_ACTIVATED", 8);
        public static final /* enum */ d j = new d("ORIENTATION_ANGLE_CHANGE", 9);
        private static final /* synthetic */ d[] k;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private d() {
            void var2_-1;
            void var1_-1;
        }

        static {
            k = new d[]{a, b, c, d, e, f, g, h, i, j};
        }
    }
}

