/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidgamesdk;

import android.app.Activity;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SwappyDisplayManager
implements DisplayManager.DisplayListener {
    private final String LOG_TAG = "SwappyDisplayManager";
    private final boolean DEBUG = false;
    private final long ONE_MS_IN_NS = 1000000L;
    private final long ONE_S_IN_NS = 1000000000L;
    private long mCookie;
    private Activity mActivity;
    private WindowManager mWindowManager;
    private Display.Mode mCurrentMode;
    private a mLooper;

    private boolean modeMatchesCurrentResolution(Display.Mode mode) {
        return mode.getPhysicalHeight() == this.mCurrentMode.getPhysicalHeight() && mode.getPhysicalWidth() == this.mCurrentMode.getPhysicalWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwappyDisplayManager(long l2, Activity activity) {
        Object object;
        try {
            object = activity.getPackageManager().getActivityInfo(activity.getIntent().getComponent(), 128);
            if (object.metaData != null && (object = object.metaData.getString("android.app.lib_name")) != null) {
                System.loadLibrary((String)object);
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"SwappyDisplayManager", (String)throwable.getMessage());
        }
        this.mCookie = l2;
        this.mActivity = activity;
        this.mWindowManager = (WindowManager)this.mActivity.getSystemService(WindowManager.class);
        object = this.mWindowManager.getDefaultDisplay();
        this.mCurrentMode = object.getMode();
        this.updateSupportedRefreshRates((Display)object);
        object = (DisplayManager)this.mActivity.getSystemService(DisplayManager.class);
        SwappyDisplayManager swappyDisplayManager = this;
        synchronized (swappyDisplayManager) {
            this.mLooper = new a(0);
            this.mLooper.start();
            object.registerDisplayListener((DisplayManager.DisplayListener)this, this.mLooper.a);
            return;
        }
    }

    private void updateSupportedRefreshRates(Display modeArray) {
        modeArray = modeArray.getSupportedModes();
        int n2 = 0;
        for (int i2 = 0; i2 < modeArray.length; ++i2) {
            if (!this.modeMatchesCurrentResolution(modeArray[i2])) continue;
            ++n2;
        }
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        n2 = 0;
        for (int i3 = 0; i3 < modeArray.length; ++i3) {
            if (!this.modeMatchesCurrentResolution(modeArray[i3])) continue;
            lArray[n2] = (long)(1.0E9f / modeArray[i3].getRefreshRate());
            nArray[n2] = modeArray[i3].getModeId();
            ++n2;
        }
        this.nSetSupportedRefreshRates(this.mCookie, lArray, nArray);
    }

    public void setPreferredRefreshRate(final int n2) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                Window window = SwappyDisplayManager.this.mActivity.getWindow();
                WindowManager.LayoutParams layoutParams = window.getAttributes();
                window.getAttributes().preferredDisplayModeId = n2;
                window.setAttributes(layoutParams);
            }
        });
    }

    public void terminate() {
        this.mLooper.a.getLooper().quit();
    }

    public void onDisplayAdded(int n2) {
    }

    public void onDisplayRemoved(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayChanged(int n2) {
        SwappyDisplayManager swappyDisplayManager = this;
        synchronized (swappyDisplayManager) {
            Display display = this.mWindowManager.getDefaultDisplay();
            float f2 = display.getRefreshRate();
            Display.Mode mode = display.getMode();
            boolean bl = mode.getPhysicalWidth() != this.mCurrentMode.getPhysicalWidth() | mode.getPhysicalHeight() != this.mCurrentMode.getPhysicalHeight();
            boolean bl2 = f2 != this.mCurrentMode.getRefreshRate();
            this.mCurrentMode = mode;
            if (bl) {
                this.updateSupportedRefreshRates(display);
            }
            if (this.callNativeCallback() && bl2) {
                long l2 = display.getAppVsyncOffsetNanos();
                long l3 = this.mWindowManager.getDefaultDisplay().getPresentationDeadlineNanos();
                long l4 = (long)(1.0E9f / f2);
                long l5 = l4 - (l3 - 1000000L);
                this.nOnRefreshRateChanged(this.mCookie, l4, l2, l5);
            }
            return;
        }
    }

    private boolean callNativeCallback() {
        return Build.VERSION.SDK_INT < 29 || Build.VERSION.SDK_INT == 29 && Build.VERSION.PREVIEW_SDK_INT == 0;
    }

    private native void nSetSupportedRefreshRates(long var1, long[] var3, int[] var4);

    private native void nOnRefreshRateChanged(long var1, long var3, long var5, long var7);

    private final class a
    extends Thread {
        public Handler a;
        private Lock c = new ReentrantLock();
        private Condition d = this.c.newCondition();

        private a() {
        }

        @Override
        public final void start() {
            this.c.lock();
            super.start();
            try {
                this.d.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.c.unlock();
        }

        @Override
        public final void run() {
            Log.i((String)"SwappyDisplayManager", (String)"Starting looper thread");
            this.c.lock();
            Looper.prepare();
            this.a = new Handler();
            this.d.signal();
            this.c.unlock();
            Looper.loop();
            Log.i((String)"SwappyDisplayManager", (String)"Terminating looper thread");
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

