using UnityEngine;

public class MoveCharacter : MonoBehaviour
{
    //vitesse de dplacement
    public float moveSpeedCharacter;

    //variable valeur de saut
    public float jumpForce;
    private int extraJump;
    public int extraJumpValue;

    //boolean pour le saut
    private bool isJumping;
    public bool isGrounded;

    public Transform groundCheck;
    public float groundCheckRadius;
    public LayerMask collisionLayers;

    //public CapsuleCollider2D playerCollider;

    //rigidbody du personnage
    public Rigidbody2D rb;
    public Animator animator;
    public SpriteRenderer spriteRenderer;

    private bool m_FacingRight = true;  // For determining which way the player is currently facing.

    private Vector3 velocity = Vector3.zero;

    private float horizontalMovement;

    [SerializeField] private AudioClip jump = null;
    private AudioSource perso_AudioSource;

    public static MoveCharacter instance;

  

 
    private void Awake()
    {
        if(instance != null)
        {
            Debug.LogWarning("plus d'une d'instance MoveCharacter");
            return;
        }

        instance = this;
        perso_AudioSource = GetComponent<AudioSource>();
        
        
    }


    private void Start()
    {
        extraJump = extraJumpValue;
    }


    void Update()
    {
        //calculer le mouvement du personnage

        //methode sans joystick
        horizontalMovement = Input.GetAxis("Horizontal") * moveSpeedCharacter * Time.fixedDeltaTime;
       
        //saut
        if (isGrounded == true)
        {
            extraJump = 1;
        }
        if (Input.GetKeyDown("space") && extraJump > 0)
        {
            isJumping = true;
            extraJump--;
            animator.SetBool("IsJumping", true);
        } else if (Input.GetKeyDown("space") && extraJump == 0 && isGrounded == true)
        {
            isJumping = true;
            animator.SetBool("IsJumping", true);
        } 

        //on envoi la vitesse  l'animation
        //characterVelocity permet de grer les valeurs ngatives du dplacement (si le personnage recule les valeurs ne vont pas tre ngative car ce n'est pas logique)
        float characterVelocity = Mathf.Abs(rb.velocity.x);
        animator.SetFloat("Speed", characterVelocity);
    }

    void FixedUpdate()
    {
        bool wasGrounded = isGrounded;
        isGrounded = false;
       

        Collider2D[] colliders = Physics2D.OverlapCircleAll(groundCheck.position, groundCheckRadius, collisionLayers);
        for (int i = 0; i < colliders.Length; i++)
        {
            if (colliders[i].gameObject != gameObject)
            {
                isGrounded = true;
                if (!wasGrounded)
                    animator.SetBool("IsJumping", false);
            }
        }
        //dplacement du joueur
        MovementPlayer(horizontalMovement);
    }

    void MovementPlayer(float _horizontalMovement)
    {
        Vector3 targetVelocity = new Vector2(_horizontalMovement, rb.velocity.y);
        rb.velocity = Vector3.SmoothDamp(rb.velocity, targetVelocity, ref velocity, .05f);

        // If the input is moving the player right and the player is facing left...
        if (_horizontalMovement > 0 && !m_FacingRight)
        {
            // ... flip the player.
            Flip();
        }
        // Otherwise if the input is moving the player left and the player is facing right...
        else if (_horizontalMovement < 0 && m_FacingRight)
        {
            // ... flip the player.
            Flip();
        }

        //saut
        if (isJumping == true)
        {
            rb.AddForce(new Vector2(0f, jumpForce));
            isJumping = false;

            perso_AudioSource.PlayOneShot(jump);

            Debug.Log("Jump");
        }

        
    }

    private void Flip()
    {
        // Switch the way the player is labelled as facing.
        m_FacingRight = !m_FacingRight;

        // Multiply the player's x local scale by -1.
        Vector3 theScale = transform.localScale;
        theScale.x *= -1;
        transform.localScale = theScale;
    }

    private void OnDrawGizmos()
    {
        Gizmos.color = Color.red;
        Gizmos.DrawWireSphere(groundCheck.position, groundCheckRadius);
    }

}
