using UnityEngine;
using UnityEngine.UI;

public class Inventory : MonoBehaviour {
    public int coinsCount;
    public Text coinsCountText;

    [SerializeField] private AudioClip coin = null;
    private AudioSource perso_AudioSource;

    public static Inventory instance;

    private void Awake () {
        if (instance != null) {
            Debug.LogWarning ("Il y a plus d'une instance de Inventory dans la scène");
            return;
        }
        instance = this;
        perso_AudioSource = GetComponent<AudioSource>();
    }

    public void AddCoins(int count){
        coinsCount += count;
        coinsCountText.text = coinsCount.ToString();
        perso_AudioSource.PlayOneShot(coin);
    }
}