using System.Collections;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameOverManager : MonoBehaviour
{

    public GameObject gameOverUI;

    //pour creer une instance de gameovermanager
    public static GameOverManager instance;
    private void Awake()
    {
        if (instance != null)
        {
            Debug.LogWarning("plus d'une d'instance GameOverManager");
            return;
        }

        instance = this;
    }

    //active le menu de game over
    public void OnPlayerDeath()
    {

        if (CurrentSceneManager.instance.isPlayerPresentByDefault)
        {
            DontDestroyOnLoadScene.instance.RemoveFromDontDestroyOnLoad();
        }

        WaitingMenu();
        gameOverUI.SetActive(true);

    }

    //recommencer le niveau
    public void Retry()
    {
        
        SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex);
        PlayerHealth.instance.Respawn();
        gameOverUI.SetActive(false);
    }

    //aller au menu principal
    public void Menu()
    {
        DontDestroyOnLoadScene.instance.RemoveFromDontDestroyOnLoad();
        SceneManager.LoadScene("MainMenu");
    }

    //quitter le jeu
    public void Quit()
    {
        Application.Quit();
    }

    private IEnumerator WaitingMenu()
    {
       
        yield return new WaitForSeconds(1);
    
       
    }
}

