using UnityEngine;

public class PlayerMovement : MonoBehaviour
{
	public float moveSpeed; 
    public float jumpForce;

    public bool isJumping;
    public bool isGrounded; 

    public Transform groundCheck;
    public float groundCheckRadius;
    public LayerMask collisionLayers; 

    public Joystick joystick;

	public Rigidbody2D rb;
	public Animator animator;
    public SpriteRenderer spriteRenderer;
    public CapsuleCollider2D playerCollider;

    public AudioSource audioSource;
    public AudioClip sound;


	private Vector3 velocity = Vector3.zero;
    private float horizontalMovement;

    public static PlayerMovement instance;

    private void Awake() {
        if (instance !=null)
        {
            Debug.LogWarning("Il y a plus d'une instance de PlayerMovement dans la scéne");
            return;

        }

        instance = this;
    }

    void Update()
    {
        
        horizontalMovement = joystick.Horizontal * moveSpeed * Time.fixedDeltaTime;

        float verticalMove = joystick.Vertical;

        if(Input.GetButtonDown("Jump") | verticalMove >= .5f && isGrounded)
       { 

        isJumping = true; 
        // audioSource.PlayOneShot(sound);

        } 

        Flip(rb.velocity.x);

		float characterVelocity = Mathf.Abs(rb.velocity.x); 
        animator.SetFloat("Speed", characterVelocity);
    }

    void FixedUpdate()
    {
        
        isGrounded = Physics2D.OverlapCircle(groundCheck.position, groundCheckRadius, collisionLayers);

        MovePlayer(horizontalMovement);
    }
    void MovePlayer(float _horizontalMovement)
    {
    	Vector3 targetVelocity = new Vector2(_horizontalMovement, rb.velocity.y);
    	rb.velocity = Vector3.SmoothDamp(rb.velocity, targetVelocity, ref velocity, .05f);

        if(isJumping == true)
{
    rb.AddForce(new Vector2(0f, jumpForce));
    isJumping = false;
}

    }
    void Flip(float _velocity)
    {

            if (_velocity > 0.1f) 
            {

                spriteRenderer.flipX = false; 
            } else if (_velocity < -0.1f) 
            {

                spriteRenderer.flipX = true;
            }



    }

    private void OnDrawGizmos()
    {
        Gizmos.color = Color.red;
        Gizmos.DrawWireSphere(groundCheck.position, groundCheckRadius);
    }
    
}



