﻿using UnityEngine;
using UnityEngine.SceneManagement;

public class DontDestroyOnLoadScene : MonoBehaviour
{
   public GameObject[] objects;

   public static DontDestroyOnLoadScene instance;

    private void Awake() {
        if (instance !=null)
        {
            Debug.LogWarning("Il y a plus d'une instance de DontDestroyOnLoadScene dans la scéne");
            return;
        }

        instance = this;

         foreach (var element in objects)
       {
           DontDestroyOnLoad(element);
       }
    }

   void RemoveFromDontDestroyOnLoad()
   {
       foreach (var element in objects)
       {
           SceneManager.MoveGameObjectToScene(element, SceneManager.GetActiveScene());
       }
   }
}
