﻿using UnityEngine;
using UnityEngine.UI;

public class Inventory : MonoBehaviour
{
    public int keysCount;
    public Text keysCountText;

    public static Inventory instance;

    private void Awake() 
    {
        if(instance != null)
        {
            Debug.LogWarning("Il y a plus d'une instance de Inventory dans la scène");
            return;
        }

        instance = this;   
    }

    public void AddKeys(int count)
    {
        keysCount += count;
        keysCountText.text = keysCount.ToString();
    }

    public void RemoveKeys(int count)
    {
        if(keysCount > 0)
        {
            keysCount -= count;
            keysCountText.text = keysCount.ToString();
        }  
    }
}
