﻿using UnityEngine;
using UnityEngine.SceneManagement;

public class GameOverManager : MonoBehaviour
{
    public GameObject gameOverUI;

    public static GameOverManager instance;
    public AudioClip gameOverSound;

    private void Awake() 
    {
        if(instance != null)
        {
            Debug.LogWarning("Il y a plus d'une instance de GameOverManager dans la scène");
            return;
        }

        instance = this;   
    }

    public void OnPlayerDeath()
    {
        AudioManager.instance.PlayClipAt(gameOverSound, transform.position);
        gameOverUI.SetActive(true);
    }  

    public void RetryButton()
    {
        //Recommencer le niveau
        SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex); //Recharge la scène
        gameOverUI.SetActive(false);
    }

    public void MainMenuButton()
    {
        //Retour au menu principal
        SceneManager.LoadScene("MainMenu");
    }
    public void QuitButton()
    {
        //Fermer le jeu
        Application.Quit();
    }
}

