﻿using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

public class Chest : MonoBehaviour
{
    public GameObject winMenuUI;

    private Text interactUI;
    private bool isInRange;

    public int keyToRemove;

    public AudioClip winSound;

    void Awake()
    {
        interactUI = GameObject.FindGameObjectWithTag("InteractUI").GetComponent<Text>();
    }

    
    void Update()
    {
        if(Input.GetKeyDown(KeyCode.E) && isInRange)
        {
            OpenChest();
            Congratulations();
            AudioManager.instance.PlayClipAt(winSound, transform.position);
        }        
    }

    #if UNITY_ANDROID
    public void Action()
    {
        if(isInRange)
        {
            OpenChest();
            Congratulations();
            AudioManager.instance.PlayClipAt(winSound, transform.position);
        }     
    }
    #endif

    void OpenChest()
    {
        Inventory.instance.RemoveKeys(keyToRemove);
        Debug.Log("Félicitations");
    }

    public void Congratulations()
    {
        winMenuUI.SetActive(true);
        PlayerMovement.instance.enabled = false;
        PlayerMovement.instance.rb.bodyType = RigidbodyType2D.Kinematic;
        PlayerMovement.instance.rb.velocity = Vector3.zero;
        PlayerMovement.instance.playerCollider.enabled = false;
    }  

    public void RetryButton()
    {
        //Recommencer le niveau
        SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex); //Recharge la scène
        winMenuUI.SetActive(false);
    }

    public void CreditsButton()
    {
        SceneManager.LoadScene("Credits");
    }


    public void MainMenuButton()
    {
        //Retour au menu principal
        SceneManager.LoadScene("MainMenu");
    }
    public void QuitButton()
    {
        //Fermer le jeu
        Application.Quit();
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if(collision.CompareTag("Player"))
        {
            interactUI.enabled = true;
            isInRange = true;
        }
    }

    private void OnTriggerExit2D(Collider2D collision)
    {
        if(collision.CompareTag("Player"))
        {
            interactUI.enabled = false;
            isInRange = false;
        }
    }
}
